package it.eng.eremita.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.types.Identifiable;
import it.eng.eremita.graphql.types.Trackable;

@Entity
@Table(name="EREMITA_SEGNAL_ALTRE_SPECIE")
@SequenceGenerator(name="SEQ_SEGNAL_ALTRE_SPECIE", sequenceName="SEQ_SEGNAL_ALTRE_SPECIE", initialValue=1, allocationSize=1)
public class SegnalazioneAltreSpecie implements Serializable, Identifiable<Long>, Trackable<Utente,Long> {
	
	Long id;
	MonitoraggioSpecie monitoraggioSpecie;
	Specie specie;
	StadioSviluppo stadioSviluppo;
	BigDecimal esemplariM;
	BigDecimal esemplariF;
	BigDecimal esemplariMF;
	TipoReperto tipoReperto;
	String note;
	
	Utente utenteCreazione;
	Utente utenteModifica;
	Date dataCreazione;
	Date dataModifica;
	
	@Id
	@GeneratedValue(strategy=GenerationType.SEQUENCE,generator="SEQ_SEGNAL_ALTRE_SPECIE")
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	
	@ManyToOne
	@JoinColumn(name="MONITORAGGIO_SPECIE")
	@GraphQLQuery(name="monitoraggioSpecie")
	public MonitoraggioSpecie getMonitoraggioSpecie() {
		return monitoraggioSpecie;
	}
	public void setMonitoraggioSpecie(MonitoraggioSpecie monitoraggioSpecie) {
		this.monitoraggioSpecie = monitoraggioSpecie;
	}
	
	
	@Column(name="NOTE2",length=1024)
	@GraphQLQuery(name="note")
	public String getNote() {
		return note;
	}
	public void setNote(String note) {
		this.note = note;
	}
	@ManyToOne
	@JoinColumn(name="SPECIE")
	@GraphQLQuery(name="specie")
	public Specie getSpecie() {
		return specie;
	}
	public void setSpecie(Specie specie) {
		this.specie = specie;
	}
	
	@ManyToOne
	@JoinColumn(name="STADIO_SVILUPPO")
	@GraphQLQuery(name="stadioSviluppo")
	public StadioSviluppo getStadioSviluppo() {
		return stadioSviluppo;
	}
	public void setStadioSviluppo(StadioSviluppo stadioSviluppo) {
		this.stadioSviluppo = stadioSviluppo;
	}
	
	@Column(name="ESEMPLARI_M")
	@GraphQLQuery(name="esemplariM")
	public BigDecimal getEsemplariM() {
		return esemplariM;
	}
	public void setEsemplariM(BigDecimal esemplariM) {
		this.esemplariM = esemplariM;
	}
	
	@Column(name="ESEMPLARI_F")
	@GraphQLQuery(name="esemplariF")
	public BigDecimal getEsemplariF() {
		return esemplariF;
	}
	public void setEsemplariF(BigDecimal esemplariF) {
		this.esemplariF = esemplariF;
	}
	
	@Column(name="ESEMPLARI_MF")
	@GraphQLQuery(name="esemplariMF")
	public BigDecimal getEsemplariMF() {
		return esemplariMF;
	}
	public void setEsemplariMF(BigDecimal esemplariMF) {
		this.esemplariMF = esemplariMF;
	}
	
	@ManyToOne
	@JoinColumn(name="TIPO_REPERTO")
	@GraphQLQuery(name="tipoReperto")
	public TipoReperto getTipoReperto() {
		return tipoReperto;
	}
	public void setTipoReperto(TipoReperto tipoReperto) {
		this.tipoReperto = tipoReperto;
	}
	
	@ManyToOne
	@JoinColumn(name="UTENTE_CREAZIONE")
	@GraphQLQuery(name="utenteCreazione")
	public Utente getUtenteCreazione() {
		return utenteCreazione;
	}

	public void setUtenteCreazione(Utente utenteCreazione) {
		this.utenteCreazione = utenteCreazione;
	}

	@ManyToOne
	@JoinColumn(name="UTENTE_MODIFICA")
	@GraphQLQuery(name="utenteModifica")
	public Utente getUtenteModifica() {
		return utenteModifica;
	}

	public void setUtenteModifica(Utente utenteModifica) {
		this.utenteModifica = utenteModifica;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_CREAZIONE")
	@GraphQLQuery(name="dataCreazione")
	public Date getDataCreazione() {
		return dataCreazione;
	}

	public void setDataCreazione(Date dataCreazione) {
		this.dataCreazione = dataCreazione;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="DATA_MODIFICA")
	@GraphQLQuery(name="dataModifica")
	public Date getDataModifica() {
		return dataModifica;
	}

	public void setDataModifica(Date dataModifica) {
		this.dataModifica = dataModifica;
	}
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof SegnalazioneAltreSpecie)) return false;
		
		SegnalazioneAltreSpecie ms = (SegnalazioneAltreSpecie)o;
		return (ms.getId()==this.getId());

	}
	
	@Override
	public String toString() {
		return "SegnalazioneAltreSpecie-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (int)( getId()%Integer.MAX_VALUE);
	}
	

}
